function Save(handles)
% This function saves the currently shown image on the graph in the GUI.

%% Get Handles
SavePath  = get(handles.SavePath,'String');
FileName  = get(handles.FileName,'String');
Axis      = get(handles.Load,'UserData');
Data      = get(handles.CAxisMax,'UserData');
Image     = Data{1};
B         = Data{2};
AxPosMax  = round(get(handles.CAxisMax,'Value'),3);
AxPosMin  = round(get(handles.CAxisMin,'Value'),3);
ScaleY    = Axis(1);
ScaleX    = Axis(2);
XMax      = ScaleX*size(Image,2)/2;
YMax      = ScaleY*size(Image,1)/2;
AxisX     = linspace(-XMax,XMax,size(Image,2));
AxisY     = linspace(YMax,-YMax,size(Image,1));
Pos       = get(handles.Slider,'Value');
Range     = get(handles.Slider, 'SliderStep');
Energies  = str2double(get(handles.DispRange,'String'));
Contours  = get(handles.Contours,'Value');
Pos       = round(Pos/Range(1))*Range(1);
Energies  = Energies/2;
cmax      = max(max(Image));
cmin      = min(min(Image));
CMax      = cmax *AxPosMax;
CMin      = cmin + (cmax-cmin)*AxPosMin;
fig=figure;
imagesc(AxisX,AxisY,Image);
colormap(hot(255));
colorbar;
title(['EELS-Map @ ',num2str(Pos),' ± ',num2str(Energies),' eV']);
caxis([CMin,CMax]);
xlabel( 'x [nm]' );
ylabel( 'y [nm]' );
axis('equal');
set(gca,'YDir','normal')
set(gca,'FontSize',16);
if Contours==1
    hold on
    for k = 2:length(B)
        boundary = B{k}-1;
        plot(boundary(:,2), boundary(:,1), 'b', 'LineWidth', 2);
    end
end
xlim([-XMax,XMax]);
ylim([-YMax,YMax]);
savefig(fig,[SavePath,'\' FileName,'_',num2str(round(Pos,2)),'eV','.fig']);
clearvars all

end